#!/usr/bin/python3
import os
import sys
import json
import re
import time
import csv
import getpass
import configparser
import sys
import getopt
import tempfile
import platform
import requests

# Defining functions
def api(prefix,input):
    apis = prefix + input
    se = requests.session()
    myVal = se.post(apis) 
    return myVal.json()

# Initalizing
print("QRecorder V1.0")
print("  Designed by Ph.D ZHAN YONGJIA, CAPITAL NORMAL UNIVERSITY")
print("  Author: Yongjia Zhan")
print("  E-mail: zhanyj@cnu.edu.cn")
print("  USAGE: ','QRecorder -i[--ifile] <inputfile> ")
print("Press Crtl+C or exit the program")
print(" ----------------------------------------------------------")
user = getpass.getuser()

# Loading the config file
configfile = ''
if sys.argv[1:] == []:
    print("Warning! Please add parameters following the USAGE.")
    print(" ----------------------------------------------------------")
    sys.exit()
else:
    try:
        opts, params = getopt.getopt(sys.argv[1:],"i:",["ifile="])
    except getopt.GetoptError:
        print('QRecorder -i[--ifile] <inputfile> ')
        sys.exit()
    for opt, arg in opts:
        if opt in ("-i", "--ifile"):
            configfile = arg

# Verifing the config file
  #(1) Checking the config file can be found and be accessed or not.
try:
    f = open(configfile)
except FileNotFoundError:
    print("Warning! The config file does not exist!" )
    print(" ----------------------------------------------------------")
    sys.exit()
except PermissionError:
    print("Warning! The current user("+ user \
                +") have not the permission to access the config file(" \
                + configfile +") !" )
    print(" ----------------------------------------------------------")
    sys.exit()
else:
  #(2) Checking the validation of the config file.
    try:
        config = configparser.ConfigParser()
        config.read(configfile, encoding='utf-8')
        setting = config.get('DECODE','name')
        delimiters = config.get('DECODE','delimiters')
        minIntervalTime = int(config.get('DECODE','minIntervalTime'))
        header = "DATETIME,USER," + config.get('DECODE','HEADER')
        replaceStrs =   re.split(',',config.get('DECODE','replaceStrs'))
        BarcodeSites =  re.split(',',config.get('DECODE','BarcodeSites'))
        isPrint = config.get('DECODE','isPrint')
        exception = config.get('DECODE','exception')
        api_prefix = config.get('DECODE','api_prefix')
        api_output = config.get('DECODE','api_output')
    except:
        print('    Warning! The config file('+ configfile+') is not valid!')
        print(" ----------------------------------------------------------")
        sys.exit()
    else:
        print('The config file('+ configfile +') is loaded successfully!')
        print(" ----------------------------------------------------------")
        f.close()
# Setting the working directory
if os.path.exists(setting):
    os.chdir(setting)
else:
    os.mkdir(setting)
    os.chdir(setting)
    os.mkdir("prtfiles")
    os.mkdir("raws")
if os.path.exists(setting+".csv"):
    print("Appending to the existing file: " + setting+".csv")
    print("(Last modified Time: %s" % time.ctime(os.path.getmtime(setting+".csv"))+")")
    print(" ----------------------------------------------------------")
    print("                                                           ")
else:
    f0 = open((setting+".csv"),"a+")
    f0.write(header + "," + config.get('DECODE','note') +"\n")
    f0.close()

# Reading the input QRcode data
i = 0; rec=""; QRcode="" ; scanTime = 0
today = time.strftime("%Y%m%d", time.localtime())
rec = today
while rec != "":
    hint = "**Scanning QRcode_" + str(i+1).zfill(3) + ": "
    QRcode = input(hint)
    # 1. replace QRcode using specified string (optional)
    if replaceStrs != ['']and QRcode != 'exit':
        for replaceStr in replaceStrs:
            rStr = re.split('/',replaceStr)
            QRcode = re.sub(rStr[0],rStr[1],QRcode)
    # 2. split the Barcode string based on Barcode sites (optional)
    Barcode = ''
    if QRcode == 'exit':
        break
    elif BarcodeSites == ['']:
        Barcode = QRcode
    elif delimiters == '':
        Barcode = QRcode
        QRcode = QRcode + ','
        for BarcodeSite in BarcodeSites:
            rSite = re.split('-',BarcodeSite)
            QRcode = QRcode + QRcode[(int(rSite[0])-1):int(rSite[1])] + ','
    # 3. set the minimal intervalTime when scanning
    lastscanTime = scanTime
    scanTime = int(time.time())
    intervalTime = scanTime-lastscanTime
    #print('Interval:',intervalTime,'s')
    if intervalTime <= minIntervalTime:
        QRcode = "" 
    # 4. write raw data into QRecorder_raw.txt file everyday
    if QRcode == "exit":
        break
    else:
        f1 = open(("./raws/"+setting+today+"@"+user+"-QRecorder_raw.txt"),"a+")
        f1.write(QRcode + "\n")
        f1.close()
        mytime = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
        if config.get('DECODE','note') == "" or intervalTime < minIntervalTime:
            note = ""
        else:
            note = input("**Input "+config.get('DECODE','note')+" : ")
    # 5. Generating raw data into QRecorder_raw.txt file everyday
        HEADER = header.split(',')
        if delimiters == '':
            arrayRec = [mytime] + [user] + re.split(',',QRcode)
        else:
            arrayRec = [mytime] + [user] + re.split(delimiters,QRcode)
    # 6. Verifing the input QRcode data and writing to the output csv file.
        if len(arrayRec) >= len(HEADER):
            dictRec = {}; n = 0
            while n < len(HEADER):
                dictRec[HEADER[n]] = arrayRec[n]
                n = n + 1
            if api_prefix =="":
                dictRec[config.get('DECODE','note')] = note
            else:
                dictRec['ApiName'] = note
                #print(dictRec)
                api_output_str = api(api_prefix,dictRec[api_output])
                dictRec['ApiValue'] = str(api_output_str)
            if eval(exception):
                print("    Warning! The QRcode/Barcode is an exception!","(",exception,")")
                print("    QRcode:",QRcode)
                print("   Barcode:",Barcode)
                print("                                                           ")
            else:
                jRec = json.dumps(dictRec,indent=4,ensure_ascii=False)
             # (1) showing the QRecord on screen.
                print(jRec)
                print("                                                           ")
             # (2) generating the tempratory file and printing(optional).
                if isPrint != "":
                    prtstr = ""
                    prtHEADER = isPrint.split(',')
                    for h in prtHEADER:
                        if h in dictRec: 
                            prtstr = prtstr + (h + ": " + dictRec[h] +"\n")
                        else:
                            print("    Warning! The header",h,"seems not in the list of printing headers.")
                    prtfilename = "./prtfiles/" + str(int(time.time())) + "prtfile.txt"
                    prtfile = open (prtfilename, "w")
                    prtfile.write(prtstr)
                    prtfile.close()
                    print("Waiting for printing (based on running the StartMonitoring.ps1)......")
                    print(" ----------------------------------------------------------")
                    if platform.system() == "Linux":
                        try:
                            os.system("sz " + prtfilename)
                            print("The prtfile.txt had been downloaded via ZMODEM.")
                            print("                                               ")
                        except:
                            print("    Warning! File transfered failure via ZMODEM.")
                            print("                                                ")
              # (3) writing all QRecords to a output csv file.
                f2 = open((setting+".csv"),"a+", newline="")
                writer = csv.DictWriter(f2, dictRec.keys())
                writer.writerow(dictRec)
                f2.close()
        else:
            if intervalTime <= minIntervalTime:
                print("    Warning! The current interval time ("+str(intervalTime)+"s)","between", \
                         str(i).zfill(3),"and", str(i+1).zfill(3),"is less than",str(minIntervalTime)+"s")
            else:
                print("    Warning! The input QRcode data ("+ str(len(arrayRec)) + \
			" HEADER) does not match the header ("+ \
				str(len(HEADER))+" HEADER)!")
            print(" ----------------------------------------------------------")
            print("                                                           ")
    # 4. increase the record number
    i = i + 1   
# Exiting the QRecorder program.
print("GoodBye!")
